# Local Network API Server

This project hosts a simple Flask-based API server that provides Earth/Mars time and simulated DHT22 sensor data. It is designed to be accessible on your local network.

## Setup

1.  **Prerequisites**: Ensure you have Python 3 installed.
2.  **Install Dependencies**:
    It is recommended to use a virtual environment.
    ```bash
    python3 -m venv venv
    source venv/bin/activate  # On Windows use `venv\Scripts\activate`
    pip install -r requirements.txt
    ```

## Running the Server

1.  **Start the Server**:
    ```bash
    source venv/bin/activate
    python3 api_server.py
    ```
    The server will start on port `5000` and listen on all network interfaces (`0.0.0.0`).

2.  **Accessing form Local Network**:
    Find your computer's local IP address (e.g., `ifconfig` on Mac/Linux or `ipconfig` on Windows).
    Access the APIs via: `http://<YOUR_IP_ADDRESS>:5000/<ENDPOINT>`

## API Endpoints

### 1. Time API
Returns the current local Earth time and the calculated Coordinated Mars Time (MTC).

-   **URL**: `/time`
-   **Method**: `GET`
-   **Response Example**:
    ```json
    {
      "earth_time": "2025-12-20T12:20:10+05:30",
      "mars_time": "15:18:31 MTC"
    }
    ```

### 2. DHT22 Sensor API
Returns simulated temperature and humidity values, emulating a DHT22 sensor.

-   **URL**: `/dht22`
-   **Method**: `GET`
-   **Response Example**:
    ```json
    {
      "temperature": 24.5,
      "humidity": 48.2
    }
    ```
