# LLM Interaction Server for ESP32

This API serves as a bridge between an ESP32 companion bot and OpenAI's LLMs. It processes sensor data and user interactions to generate concise responses suitable for OLED displays.

## Features
- **Contextual Awareness**: Incorporates Temperature, Humidity, Earth Time, and Mars Time into the prompt.
- **Persistent Memory**: Maintains conversation history in `conversation_history.json`.
- **OLED Optimized**: Responses are strictly limited to a few words (approx 15 words) for easy reading on small screens.
- **Fail-Safe**: Returns a mock response if no API key is provided.

## Setup

1.  **Prerequisites**:
    - Python 3.x installed.
    - An OpenAI API Key.

2.  **Installation**:
    Navigate to this directory and install dependencies:
    ```bash
    cd LLM_Interaction_APIs
    pip install -r requirements.txt
    ```

3.  **Configuration**:
    Set your OpenAI API Key as an environment variable:
    ```bash
    export OPENAI_API_KEY="your-api-key-here"
    ```
    *(On Windows, use `set OPENAI_API_KEY=your-api-key-here`)*

## Usage

1.  **Start the Server**:
    ```bash
    python server.py
    ```
    The server will start on `0.0.0.0:5001`.

2.  **API Endpoint**:
    - **URL**: `http://<your-ip>:5001/interact`
    - **Method**: `POST`
    - **Content-Type**: `application/json`

3.  **Request Format**:
    ```json
    {
      "temperature": 25.5,
      "humidity": 60.2,
      "earth_time": "2023-10-27T10:00:00",
      "mars_time": "Sol 12 14:30",
      "user_input": "Yes"
    }
    ```
    - `user_input`: Can be "Yes", "No", or any short text string from the astronaut.
    - If `user_input` is empty, it defaults to a status update request.

4.  **Response Format**:
    ```json
    {
      "response": "Systems nominal. Temperature is steady."
    }
    ```

## Integration with ESP32
Ensure your ESP32 is connected to the same Wi-Fi network as this server. Use `HTTPClient` to send the POST request.

## Troubleshooting
- **No Response/Error**: Check if `OPENAI_API_KEY` is set correctly.
- **Connection Refused**: Ensure the server is running and the ESP32 is using the correct IP address of your computer.
