# ESP32 Mission Control Dashboard

A simple, sci-fi themed dashboard to display real-time data from your ESP32 astronaut companion bot.

## Features
- **Real-time Monitoring**: Displays Temperature, Humidity, Earth Time, and Mars Time.
- **Comms Log**: Shows specific conversation history between the astronaut and the bot.
- **Visuals**: Dark mode "Mission Control" aesthetic.

## Setup

1. **Create and Activate Virtual Environment**
   ```bash
   python3 -m venv venv
   source venv/bin/activate
   ```

2. **Install Dependencies**
   ```bash
   pip install -r requirements.txt
   ```

3. **Run the Server**
   ```bash
   python app.py
   ```
   The server will start on port **5002**.
   Access the dashboard at: http://localhost:5002

## Webhook API

The ESP32 should send a `POST` request to `http://<YOUR_COMPUTER_IP>:5002/webhook`.

### JSON Payload Format

```json
{
  "temperature": 25.4,
  "humidity": 60.5,
  "earth_time": "2023-10-27 10:00:00 UTC",
  "mars_time": "Sol 123 14:30 MTC",
  "conversation_history": [
    {"role": "user", "text": "Open the pod bay doors."},
    {"role": "bot", "text": "I'm sorry, Dave. I'm afraid I can't do that."}
  ]
}
```

- **All fields are optional**; the dashboard will update whatever it receives.
- `conversation_history` can be an array of strings or objects.
